/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import java.text.SimpleDateFormat;
import org.openecard.common.I18n;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.ToggleText;
import org.openecard.sal.protocol.eac.EACData;

public class CVCStep
extends Step {
    public static final String STEP_ID = "PROTOCOL_EAC_GUI_STEP_CVC";
    private static final String TITLE = "step_cvc_title";
    private static final String DESCRIPTION = "step_cvc_description";
    private static final String SUBJECT_NAME = "cvc_subject_name";
    private static final String SUBJECT_URL = "cvc_subject_url";
    private static final String TERMS_OF_USAGE = "cvc_termsofusage";
    private static final String VALIDITY = "cvc_validity";
    private static final String VALIDITY_FORMAT = "cvc_validity_format";
    private static final String VALIDITY_FROM = "cvc_validity_from";
    private static final String VALIDITY_TO = "cvc_validity_to";
    private static final String ISSUER_NAME = "cvc_issuer_name";
    private static final String ISSUER_URL = "cvc_issuer_url";
    private final I18n lang = I18n.getTranslation("eac");
    private final EACData eacData;

    public CVCStep(EACData eacData) {
        super(STEP_ID);
        this.eacData = eacData;
        this.setTitle(this.lang.translationForKey(TITLE, new Object[0]));
        this.setDescription(this.lang.translationForKey(DESCRIPTION, new Object[0]));
        this.addElements();
    }

    private void addElements() {
        SimpleDateFormat dateFormat;
        Text description = new Text();
        description.setText(this.lang.translationForKey(DESCRIPTION, new Object[0]));
        this.getInputInfoUnits().add(description);
        ToggleText subjectName = new ToggleText();
        subjectName.setTitle(this.lang.translationForKey(SUBJECT_NAME, new Object[0]));
        subjectName.setText(this.eacData.certificateDescription.getSubjectName());
        this.getInputInfoUnits().add(subjectName);
        ToggleText subjectURL = new ToggleText();
        subjectURL.setTitle(this.lang.translationForKey(SUBJECT_URL, new Object[0]));
        subjectURL.setText(this.eacData.certificateDescription.getSubjectURL());
        this.getInputInfoUnits().add(subjectURL);
        ToggleText termsOfUsage = new ToggleText();
        termsOfUsage.setTitle(this.lang.translationForKey(TERMS_OF_USAGE, new Object[0]));
        termsOfUsage.setText(this.eacData.certificateDescription.getTermsOfUsage().toString());
        termsOfUsage.setCollapsed(true);
        this.getInputInfoUnits().add(termsOfUsage);
        try {
            dateFormat = new SimpleDateFormat(this.lang.translationForKey(VALIDITY_FORMAT, new Object[0]));
        }
        catch (IllegalArgumentException e) {
            dateFormat = new SimpleDateFormat();
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append(this.lang.translationForKey(VALIDITY_FROM, new Object[0]));
        sb.append(" ");
        sb.append(dateFormat.format(this.eacData.certificate.getEffectiveDate().getTime()));
        sb.append(" ");
        sb.append(this.lang.translationForKey(VALIDITY_TO, new Object[0]));
        sb.append(" ");
        sb.append(dateFormat.format(this.eacData.certificate.getExpirationDate().getTime()));
        ToggleText validity = new ToggleText();
        validity.setTitle(this.lang.translationForKey(VALIDITY, new Object[0]));
        validity.setText(sb.toString());
        validity.setCollapsed(true);
        this.getInputInfoUnits().add(validity);
        ToggleText issuerName = new ToggleText();
        issuerName.setTitle(this.lang.translationForKey(ISSUER_NAME, new Object[0]));
        issuerName.setText(this.eacData.certificateDescription.getIssuerName());
        issuerName.setCollapsed(true);
        this.getInputInfoUnits().add(issuerName);
        ToggleText issuerURL = new ToggleText();
        issuerURL.setTitle(this.lang.translationForKey(ISSUER_URL, new Object[0]));
        issuerURL.setText(this.eacData.certificateDescription.getIssuerURL());
        issuerURL.setCollapsed(true);
        this.getInputInfoUnits().add(issuerURL);
    }
}

