/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.CANEntryStep;
import org.openecard.plugins.pinplugin.gui.ChangePINStep;
import org.openecard.plugins.pinplugin.gui.PINStepAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CANStepAction
extends StepAction {
    private static final Logger logger = LoggerFactory.getLogger(CANStepAction.class);
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String CANSTEP_TITLE = "action.changepin.userconsent.canstep.title";
    private static final String PINSTEP_TITLE = "action.changepin.userconsent.pinstep.title";
    private static final String PIN_ID_CAN = "2";
    private final boolean capturePin;
    private final Dispatcher dispatcher;
    private String can;
    private ConnectionHandleType conHandle;
    private RecognizedState state;

    public CANStepAction(boolean capturePin, ConnectionHandleType conHandle, Dispatcher dispatcher, Step step, RecognizedState state) {
        super(step);
        this.capturePin = capturePin;
        this.conHandle = conHandle;
        this.dispatcher = dispatcher;
        this.state = state;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        AuthDataMap tmp;
        if (result.isBack()) {
            return new StepActionResult(StepActionResultStatus.BACK);
        }
        if (!this.state.equals((Object)RecognizedState.PIN_suspended)) {
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            tmp = new AuthDataMap(paceInput);
        }
        catch (ParserConfigurationException ex) {
            logger.error("Failed to read empty Protocol data.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        AuthDataResponse paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            if (!this.verifyUserInput(executionResults)) {
                return new StepActionResult(StepActionResultStatus.REPEAT, this.createReplacementStep(false, true));
            }
            paceInputMap.addElement("PIN", this.can);
        }
        paceInputMap.addElement("PinID", PIN_ID_CAN);
        EstablishChannel establishChannel = new EstablishChannel();
        establishChannel.setSlotHandle(this.conHandle.getSlotHandle());
        establishChannel.setAuthenticationProtocolData(paceInputMap.getResponse());
        establishChannel.getAuthenticationProtocolData().setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            EstablishChannelResponse ecr = (EstablishChannelResponse)this.dispatcher.deliver(establishChannel);
            WSHelper.checkResult(ecr);
            String title = this.lang.translationForKey(PINSTEP_TITLE, new Object[0]);
            int retryCounter = 1;
            ChangePINStep replacementStep = new ChangePINStep("pin-entry", title, this.capturePin, retryCounter, false, false);
            PINStepAction pinAction = new PINStepAction(this.capturePin, this.conHandle, this.dispatcher, replacementStep, retryCounter);
            replacementStep.setAction(pinAction);
            return new StepActionResult(StepActionResultStatus.NEXT, replacementStep);
        }
        catch (WSHelper.WSException ex) {
            logger.info("Wrong CAN entered, trying again");
            return new StepActionResult(StepActionResultStatus.REPEAT, this.createReplacementStep(true, false));
        }
        catch (InvocationTargetException ex) {
            logger.error("Exception while dispatching EstablishChannelCommand.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (DispatcherException ex) {
            logger.error("Failed to dispatch EstablishChannelCommand.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
    }

    private boolean verifyUserInput(ExecutionResults executionResults) {
        PasswordField canField = (PasswordField)executionResults.getResult("CAN_FIELD");
        this.can = canField.getValue();
        return !this.can.isEmpty() && this.can.length() == 6;
    }

    private Step createReplacementStep(boolean enteredWrong, boolean verifyFailed) {
        String title = this.lang.translationForKey(CANSTEP_TITLE, new Object[0]);
        CANEntryStep canStep = new CANEntryStep("can-entry", title, this.capturePin, this.state, enteredWrong, verifyFailed);
        CANStepAction pinAction = new CANStepAction(this.capturePin, this.conHandle, this.dispatcher, canStep, this.state);
        canStep.setAction(pinAction);
        return canStep;
    }
}

