/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.interceptor;

import java.io.IOException;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpRequestInterceptor;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.binding.http.common.HttpRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger _logger = LoggerFactory.getLogger(CORSRequestInterceptor.class);

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(httpRequest);
        if (requestWrapper.hasRequestParameter("redirectUrlAsBody")) {
            _logger.debug("CORS redirect not supported");
            httpRequest.getParams().setBooleanParameter("disable-CORS-redirect", true);
        }
    }
}

